/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.biome;

import corgiaoc.byg.config.json.biomedata.BiomeDataHolders;
import corgiaoc.byg.config.json.biomedata.WeightedBiomeData;
import corgiaoc.byg.mixin.access.BiomeAccess;
import corgiaoc.byg.mixin.access.WeightedListAccess;
import corgiaoc.byg.mixin.access.WeightedListEntryAccess;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedList;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;

public class BYGEndBiome {
    public static final List<BYGEndBiome> BYG_END_BIOMES = new ArrayList<BYGEndBiome>();
    private final Biome biome;

    public BYGEndBiome(Biome.Climate climate, Biome.Category category, float depth, float scale, BiomeAmbience effects, BiomeGenerationSettings biomeGenerationSettings, MobSpawnInfo mobSpawnInfo) {
        this.biome = BiomeAccess.create(climate, category, depth, scale, effects, biomeGenerationSettings, mobSpawnInfo);
        BYG_END_BIOMES.add(this);
    }

    public BYGEndBiome(Biome.Builder builder) {
        this.biome = builder.func_242455_a();
        BYG_END_BIOMES.add(this);
    }

    public BYGEndBiome(Biome biome) {
        this.biome = biome;
        BYG_END_BIOMES.add(this);
    }

    public Biome getBiome() {
        return this.biome;
    }

    public WeightedList<ResourceLocation> getHills() {
        return new WeightedList();
    }

    @Nullable
    public Biome getEdge() {
        return null;
    }

    public int getWeight() {
        return 5;
    }

    public String[] getBiomeDictionary() {
        return new String[]{"END"};
    }

    public RegistryKey<Biome> getKey() {
        return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Objects.requireNonNull(WorldGenRegistries.field_243657_i.func_177774_c((Object)this.biome)));
    }

    public static BiomeDataHolders.EndBiomeDataHolder extractDefaultHolder(Registry<Biome> biomeRegistry) {
        HashMap<ResourceLocation, WeightedBiomeData> biomeData = new HashMap<ResourceLocation, WeightedBiomeData>();
        HashMap<ResourceLocation, WeightedBiomeData> voidBiomeData = new HashMap<ResourceLocation, WeightedBiomeData>();
        for (BYGEndBiome bygBiome : BYG_END_BIOMES) {
            List<String> dictionary = Arrays.asList(bygBiome.getBiomeDictionary());
            WeightedList weightedListByLocation = new WeightedList();
            for (WeightedList.Entry entry : ((WeightedListAccess)bygBiome.getHills()).getEntries()) {
                weightedListByLocation.func_226313_a_(entry.func_220647_b(), ((WeightedListEntryAccess)entry).getWeight());
            }
            boolean isVoid = new HashSet<String>(dictionary).contains("VOID");
            WeightedBiomeData weightedBiomeData = new WeightedBiomeData(bygBiome.getWeight(), dictionary, bygBiome.getEdge() != null ? biomeRegistry.func_177774_c((Object)bygBiome.getEdge()) : new ResourceLocation(""), (WeightedList<ResourceLocation>)weightedListByLocation);
            ResourceLocation key = biomeRegistry.func_177774_c((Object)bygBiome.getBiome());
            if (key != null) {
                if (!isVoid) {
                    biomeData.put(key, weightedBiomeData);
                } else {
                    voidBiomeData.put(key, weightedBiomeData);
                }
            }
            for (Biome biome : biomeRegistry) {
                ResourceLocation biomeKey = biomeRegistry.func_177774_c((Object)biome);
                if (biome.func_201856_r() != Biome.Category.THEEND || biomeData.containsKey(biomeKey)) continue;
                assert (biomeKey != null);
                if (!biomeKey.equals((Object)new ResourceLocation("small_end_islands"))) {
                    biomeData.put(biomeKey, new WeightedBiomeData(5, Collections.singletonList("END"), new ResourceLocation(""), (WeightedList<ResourceLocation>)new WeightedList()));
                    continue;
                }
                voidBiomeData.put(biomeKey, new WeightedBiomeData(5, Collections.singletonList("VOID"), new ResourceLocation(""), (WeightedList<ResourceLocation>)new WeightedList()));
            }
        }
        return new BiomeDataHolders.EndBiomeDataHolder(biomeData, voidBiomeData);
    }
}

